/*
 * ESP32-C3 Веб-сервер с графическим мониторингом
 * Обновление данных и графиков каждые 5 секунд
 * Все данные на одной диаграмме
 */
#include <WiFi.h>
#include <WebServer.h>
#include "index.h"  // HTML веб-страница с графиками

// Конфигурация пинов АЦП для ESP32-C3
#define ADC_PIN1 0   // GPIO0
#define ADC_PIN2 1   // GPIO1
#define ADC_PIN3 2   // GPIO2
#define ADC_PIN4 3   // GPIO3

// Глобальные переменные для хранения значений
int adc_values[4] = {0, 0, 0, 0};
float temperature_value = 0.0;

WebServer server(80);

// Данные для Wi-Fi
const char* ssid = "YOUR_SSID";
const char* password = "YOUR_PASSWORD";

//===============================================================
// Встроенный температурный датчик ESP32-C3
//===============================================================
float readInternalTemperature() {
    // Имитация датчика температуры (замените на реальный код)
    uint8_t temp_raw = 55; // Примерное значение
    float temperature = (temp_raw - 32) / 1.8;
    return temperature + 10.0; // Смещение калибровки
}

//===============================================================
// Обработчики веб-сервера
//===============================================================
void handleRoot() {
    String s = MAIN_page;
    server.send(200, "text/html", s);
}

// Чтение всех данных сразу (для графика)
void handleAllData() {
    String json = "{";
    json += "\"temperature\":" + String(temperature_value, 1) + ",";
    json += "\"adc1\":" + String(adc_values[0]) + ",";
    json += "\"adc2\":" + String(adc_values[1]) + ",";
    json += "\"adc3\":" + String(adc_values[2]) + ",";
    json += "\"adc4\":" + String(adc_values[3]) + ",";
    json += "\"timestamp\":" + String(millis());
    json += "}";

    server.send(200, "application/json", json);
}

// Индивидуальные обработчики для AJAX
void handleADC1() {
    adc_values[0] = analogReadMilliVolts(ADC_PIN1);
    server.send(200, "text/plain", String(adc_values[0]));
}

void handleADC2() {
    adc_values[1] = analogReadMilliVolts(ADC_PIN2);
    server.send(200, "text/plain", String(adc_values[1]));
}

void handleADC3() {
    adc_values[2] = analogReadMilliVolts(ADC_PIN3);
    server.send(200, "text/plain", String(adc_values[2]));
}

void handleADC4() {
    adc_values[3] = analogReadMilliVolts(ADC_PIN4);
    server.send(200, "text/plain", String(adc_values[3]));
}

void handleTemp() {
    temperature_value = readInternalTemperature();
    server.send(200, "text/plain", String(temperature_value, 1));
}

//===============================================================
// Настройка
//===============================================================
void setup(void){
    Serial.begin(115200);
    while(!Serial){};
    delay(2000);

    Serial.println("\nЗапуск ESP32-C3 мониторинга...");

    // Настройка Wi-Fi
    WiFi.mode(WIFI_STA);
    WiFi.begin(ssid, password);

    Serial.print("Подключение к Wi-Fi ");
    Serial.println(ssid);

    int attempts = 0;
    while (WiFi.status() != WL_CONNECTED && attempts < 30) {
        delay(500);
        Serial.print(".");
        attempts++;
    }

    if (WiFi.status() == WL_CONNECTED) {
        Serial.println("\n✓ Подключено к Wi-Fi");
        Serial.print("IP адрес: ");
        Serial.println(WiFi.localIP());
    } else {
        Serial.println("\n✗ Ошибка подключения к Wi-Fi");
        // Режим точки доступа
        WiFi.mode(WIFI_AP);
        WiFi.softAP("ESP32-C3-Monitor", "12345678");
        Serial.print("AP IP адрес: ");
        Serial.println(WiFi.softAPIP());
    }

    // Настройка маршрутов веб-сервера
    server.on("/", handleRoot);
    server.on("/getAllData", handleAllData);  // Все данные в JSON
    server.on("/getTemp", handleTemp);
    server.on("/getADC1", handleADC1);
    server.on("/getADC2", handleADC2);
    server.on("/getADC3", handleADC3);
    server.on("/getADC4", handleADC4);

    server.begin();
    Serial.println("✓ HTTP сервер запущен");
}

//===============================================================
// Главный цикл
//===============================================================
void loop(void){
    server.handleClient();

    // Периодическое обновление значений (каждые 100 мс)
    static unsigned long lastUpdate = 0;
    if (millis() - lastUpdate > 100) {
        temperature_value = readInternalTemperature();
        adc_values[0] = analogReadMilliVolts(ADC_PIN1);
        adc_values[1] = analogReadMilliVolts(ADC_PIN2);
        adc_values[2] = analogReadMilliVolts(ADC_PIN3);
        adc_values[3] = analogReadMilliVolts(ADC_PIN4);
        lastUpdate = millis();
    }

    delay(1);
}