# **Проект Logger ADC, Temperature: веб-мониторинг данных с в реальном времени**

Сегодня я хочу представить вам проект **Logger ADC, Temperature** — компактный веб-сервер на базе ESP32-C3 (ядро RISC-V) для мониторинга аналоговых сигналов и температуры в реальном времени. Эта система идеально подходит для прототипирования, образовательных задач и базового мониторинга параметров в системах домашней автоматизации.

Проект создан и отлажен с цифовым помощником www.deepseek.com

## **Идея проекта**

Прошивка превращает ESP32-C3 WiFi/BT в автономное IoT-устройство, которое:
1.  Считывает напряжение с **четырёх аналоговых входов** (GPIO0-GPIO3).
2.Можно использовать внешний датчик для **измерения температуры**.
3.  Создаёт **веб-сервер** с графическим интерфейсом для отображения всех данных на одном красивом графике.
4.  **Автоматически обновляет** данные и график каждые 5 секунд без перезагрузки страницы.

Это отличная основа для создания собственных систем мониторинга, регистрации данных (даталоггера) или панели управления для DIY-проектов.

[![Модуль CORE-ESP32 WiFi/BT с ядром RISC-V.](/images/coder_esp32_C3.png)](/images/coder_esp32_C3.png)

## **Ключевые особенности кода**

*   **ESP32-C3 & Wi-Fi**: Современный и доступный чип с поддержкой Wi-Fi.
*   **4 канала АЦП**: Прецизионное считывание напряжения в милливольтах с помощью `analogReadMilliVolts()`.
*   **Веб-интерфейс "Все в одном"**: Все данные (4 канала АЦП + температура) отображаются на едином графике с временной шкалой.
*   **Двойной режим работы**: Подключение к домашней сети Wi-Fi или создание собственной точки доступа (AP), если сеть недоступна.
*   **Оптимизированный обмен данными**: Клиент получает все значения одной HTTP-запросом к `/getAllData` в формате JSON.

## **Как это использовать?**

1.  **Соберите аппаратную часть**: Подайте аналоговый сигнал (0-3.3В) на любой из пинов GPIO0, GPIO1, GPIO2 или GPIO3 ESP32-C3.
2.  **Настройте софт**: В коде укажите SSID и пароль от вашей Wi-Fi сети в переменных `ssid` и `password`.
3.  **Загрузите прошивку**: Скопируйте основной код и содержимое файла `index.h` (содержащий HTML/JS для веб-страницы) в среду Arduino IDE или PlatformIO и загрузите на плату.
4.  **Откройте веб-интерфейс**: После запуска в Serial-мониторе появится IP-адрес устройства. Откройте этот адрес в любом браузере.

Вы увидите график, на котором в реальном времени будут отображаться все пять измеряемых величин.

### **Пример реального применения**
*   **Мониторинг температуры и влажности** в помещении или теплице (при подключении соответствующих датчиков через делитель напряжения).
*   **Отслеживание напряжения** аккумулятора или солнечной панели.
*   **Контроль аналоговых датчиков** (освещённости, давления, уровня жидкости).
*   **Логирование данных** с последующей ручной выгрузкой для анализа.

## **Возможные улучшения и развитие проекта**

Этот код — отличный старт. Его можно расширить для решения более сложных задач:
*   **Добавление SD-карты** для долговременного автономного сохранения логов данных.
*   **Интеграция с облачными сервисами** (Telegram, MQTT-брокер) для отправки уведомлений.
*   **Реализация PID-регулятора** на основе полученных данных для управления внешними устройствами (реле, сервоприводами).
*   **Создание веб-форм** для настройки параметров работы прямо из интерфейса.

## **Заключение**

Logger ADC — это пример того, как современные микроконтроллеры, такие как ESP32-C3, позволяют быстро и с минимальными затратами создавать функциональные сетевые устройства для сбора и визуализации данных. Весь проект построен на открытом коде и может быть свободно модифицирован под ваши нужды.

Для технической аудитории сайта islife.ru этот проект может стать отправной точкой для более сложных разработок в области IoT, систем умного дома или лабораторного оборудования.

---
**Прошивка опубликована в ознакомительных целях. Автор не несёт ответственности за любые последствия